﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

using GE.Manager;

namespace GE.Gui
{
    /// <summary>
    /// Text widget.
    /// </summary>
    class WText : Widget
    {
        /// <summary>
        /// Font type.
        /// </summary>
        private FontType m_font;

        /// <summary>
        /// Text.
        /// </summary>
        private string m_text;

        /// <summary>
        /// Position.
        /// </summary>
        private Vector2 m_position;

        /// <summary>
        /// Color.
        /// </summary>
        private Color m_color;

        /// <summary>
        /// Font type.
        /// </summary>
        public FontType Font
        {
            set
            {
                m_font = value;
            }
        }

        /// <summary>
        /// Text.
        /// </summary>
        public string Text
        {
            get
            {
                return m_text;
            }
            set
            {
                m_text = value;
            }
        }

        /// <summary>
        /// Position.
        /// </summary>
        public Vector2 Position
        {
            set
            {
                m_position = value;
            }
        }

        /// <summary>
        /// Color.
        /// </summary>
        public Color Color
        {
            set
            {
                m_color = value;
            }
        }

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="font">font type</param>
        /// <param name="text">text</param>
        /// <param name="position">position</param>
        public WText(FontType font, string text, Vector2 position)
        {
            m_font = font;
            m_text = text;
            m_position = position;
            m_color = new Color(1f, 1f, 1f);
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="font">font type</param>
        /// <param name="text">text</param>
        /// <param name="position">position</param>
        /// <param name="color">color</param>
        public WText(FontType font, string text, Vector2 position, Color color)
        {
            m_font = font;
            m_text = text;
            m_position = position;
            m_color = color;
        }

        /// <summary>
        /// Render the widget.
        /// </summary>
        /// <param name="offset">position offset</param>
        public override void render(Vector2 offset)
        {
            base.render(offset);
            FontManager.Instance.displayText(m_font, m_text, offset + m_position, m_color);
        }
    }
}
